package furny.states;

import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.view.appstate.GUIState;
import ga.view.appstate.menu.MenuListener;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.niftygui.NiftyJmeDisplay;

import de.lessvoid.nifty.Nifty;

/**
 * This is an advanced app state which adds gui to the summary post state.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SummaryUIState<T extends IIndividual<T>> extends GUIState {
  private SummaryUIController<T> controller;
  private NiftyJmeDisplay niftyDisplay;
  private Nifty nifty;
  private AudioRenderer audioRenderer;

  private final IInteractiveFitnessEvaluator<T> evaluator;
  private final MenuListener menuListener;

  /**
   * Instantiates a new summary ui state.
   * 
   * @param evaluator
   *          the evaluator
   * @param menuListener
   *          the menu listener
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SummaryUIState(final IInteractiveFitnessEvaluator<T> evaluator,
      final MenuListener menuListener) {
    this.evaluator = evaluator;
    this.menuListener = menuListener;

  }

  @Override
  public void initialize(final AppStateManager stateManager,
      final Application app) {
    super.initialize(stateManager, app);

    this.audioRenderer = app.getAudioRenderer();

    controller = new SummaryUIController<T>(evaluator);
    controller.setMenuListener(menuListener);

    setEnabled(true);
  }

  @Override
  public void setEnabled(final boolean enabled) {
    super.setEnabled(enabled);

    if (enabled) {
      niftyDisplay = new NiftyJmeDisplay(assetManager, inputManager,
          audioRenderer, viewPort);
      nifty = niftyDisplay.getNifty();

      nifty.fromXml("furny/ui/summaryUI.xml", "start", controller);

      viewPort.addProcessor(niftyDisplay);
    } else {
      try {
        if (nifty != null) {
          viewPort.removeProcessor(niftyDisplay);
          nifty.exit();
        }
      } catch (final Exception e) {
        // ignore
      }
    }
  }

  @Override
  public void cleanup() {
    try {
      if (nifty != null) {
        viewPort.removeProcessor(niftyDisplay);
        nifty.exit();
      }
    } catch (final Exception e) {
      // ignore
    }
    super.cleanup();
  }
}
